{* modules/Users/views/Login.php *}
{strip}

<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link href="https://fonts.googleapis.com/css?family=Poppins" rel="stylesheet">
	<title>CRM Login</title>
</head>
<style>
	body {
	font-family: 'Poppins', sans-serif;
	font-size:16px;
	}

	.container{
		width:100%;
		height:100%;
		background:url("layouts/v7/modules/CustomLogin/templates/silver_coins/background.jpeg");
		background-size:cover;
		padding:0px;
        background-position:center right;
	}
	
	.bckgrd{
		width:50%;
		height:100vh;
		background:rgba(0,0,0,0.5);
		float:right !important;
	}
	
	.help{
		text-decoration:none;
		margin-left:10px;
		color:#9f9e9e;
	}

	.help:hover{
		text-decoration:underline;
		color:#fff;
	}
	
	.back{
		text-decoration:none;
		margin-left:10px;
		color:#9f9e9e;
	}

	.back:hover{
		text-decoration:underline;
		color:#fff;
	}

	.mt-15{
		margin-top:15px;
	}

	.mt-30{
		margin-top:30px;
	}

	.mtb-50{
		margin:50px 0px;
	}

	.mt-50{
		margin-top:50px;
	}

	.mt-150{
		margin-top:150px;
	}

	.white-color{
		color:white;
	}

	.purple-color{
		color:#ab2ec8;
	}

	.gray-color{
		color:gray;
	}

	.text-center{
		text-align:center;
	}

	.form-image{
		width:40%;
		height:100%;
		background:url("layouts/v7/modules/Users/images4/Radar.jpg");
		background-size:cover;
		text-align:center;
	}

	.form-content{
		width:100%;
		height:100%;
		line-height:40px;
		float:right;
		color:#fff;
	}

	.mtb{
		margin:30px 100px !important;
	}

	.login{
		width:100%;
		font-family: 'Poppins', sans-serif;
		border:1px solid #9f9e9e;
		border-radius:50px;
		padding:5px 20px;
		font-size:16px;
		background:none;
	}

	.login:focus{
		border-color:#fff;
	}

	:required:invalid{
		box-shadow:none;
	}

	.btn-login{
		border:2px solid #fff;
		border-radius:5px;
		width:20%;
		padding:5px;
		font-size:15px;
		float:right;
		background:none;
		color:white;
	}

	.btn-login:hover{
		cursor:pointer;
		background:#FFF;
		border-color:#fff;
		color:#000;
	}
	
	.left-align{
		float:left;
	}
	
	.right-align{
		float:right;
	}
	
	#page{
	padding:0% !important;
	margin:0% !important;
	}
	@media screen and (max-width:360px){
	.form-image{
		display:none;
	}
	.bckgrd{
		width:100%;
	}
	.form-content{
		width:100% !important;
		overflow:hidden;
	}
	.mtb{
		margin:20px 30px !important;
	}
	.mtb-50{
		margin:20px 0px;
	}
	.btn-login{
		width:30%;
		padding:0px;
	}
	.mt-50{
		margin-top:50px;
	}
	.login{
			width:100%;
		}
	}

	@media screen and (max-width:968px){
		.form-image{
			display:none;
		}
		.form-content{
			width:100%;
			overflow:hidden;
		}
		.login{
			width:100%;
		}
		.bckgrd{
			width:100%;
		}
		.mtb{
			margin:20px 50px;
		}
		.mtb-50{
			margin:50px 0px;
		}
	} 
</style>
<body>
<div id="page">
	<div class="container">
		<div class="bckgrd">
		<div class="form-content">
			<div id="loginDiv">
			    <div class="mt-50">
	                <div class="text-center"><img src="{$COMPANY_LOGO}"></div>
			    </div>
			    <form  class="mtb"  style="margin:0;" action="index.php?module=Users&action=Login" method="POST">
		
				{if isset($smarty.request.error)}
					<div class="alert alert-error">
					<p>Invalid username or password.</p>
					</div>
				{/if}
				
				{if isset($smarty.request.fpError)}
					<div class="alert alert-error">
					<p>Invalid Username or Email address.</p>
					</div>
				{/if}
				
				{if isset($smarty.request.statusError)}
					<div class="alert alert-error">
					<p>Outgoing mail server was not configured.</p>
					</div>
				{/if}
												
				{if isset($smarty.request.status)}
					<div class="alert alert-success">
					<p>Mail was send to your inbox, please check your e-mail.</p>
					</div>
				{/if}
			
				<div class="mt-30">

				<div class="control-group">
					<label>User Name</label><br>
					<input type="text" class="login" id="username" name="username" required>
				</div>
				</div>
				
				<div class="mt-30">
				<div class="control-group">
					<label>Password</label><br>
					<input type="password" class="login" id="password" name="password" required>  
				</div>
				</div>
				
				<div class="controls" id="forgotPassword">
				<div class="mtb-50">
					<a href="" class="help right-align">Forgot Password?</a>
					<button type="submit" class="btn-login left-align">LOGIN</button>
				</div>
				</div>
				
			</form>
			</div>
			
			<div id="forgotPasswordDiv" style="display:none;">
			
			<form class="form-register mtb"  action="forgotPassword.php"  method="POST">
			
				{if isset($smarty.request.error)}
					<div class="alert alert-error">
					<p>Invalid username or password.</p>
					</div>
				{/if}
				
				{if isset($smarty.request.fpError)}
					<div class="alert alert-error">
					<p>Invalid Username or Email address.</p>
					</div>
				{/if}
				
				{if isset($smarty.request.statusError)}
					<div class="alert alert-error">
					<p>Outgoing mail server was not configured.</p>
					</div>
				{/if}
												
				{if isset($smarty.request.status)}
					<div class="alert alert-success">
					<p>Mail was send to your inbox, please check your e-mail.</p>
					</div>
				{/if}
			
				<div class="mt-150">
				<div class="control-group">
					<label>User Name</label><br>
					<input type="text" class="login" id="username" name="username" required>
				</div>
				</div>
				
				<div class="mt-30">
				<div class="control-group">
					<label>Email</label><br>
					<input type="text" class="login" id="emailId" name="emailId" required> 
				</div>
				</div>
			
				<div class="controls" id="backButton">
				<div class="mtb-50">
					<a href="" class="back right-align">Back to Login</a>
					<button type="submit" class="btn-login left-align">Submit</button>
				</div>
				</div>
				
			</form>
			</div>
			
		</div></div>
	</div>
</div>
</body>

<script>
		jQuery(document).ready(function(){
			jQuery("#forgotPassword a").focus(function() {
				/*console.log('djnhr');*/										
									   
											jQuery("#loginDiv").hide();
	 jQuery("#forgotPasswordDiv").show();											
			});
			
			jQuery("#backButton a").focus(function() {
				jQuery("#loginDiv").show();
				jQuery("#forgotPasswordDiv").hide();
			});
			
			jQuery("input[name='retrievePassword']").click(function (){
				var username = jQuery('#user_name').val();
				var email = jQuery('#emailId').val();
				var email1 = email.replace(/^\s+/,'').replace(/\s+$/,'');
				var emailFilter = /^[^@]+@[^@.]+\.[^@]*\w\w$/ ;
				var illegalChars= /[\(\)\<\>\,\;\:\\\"\[\]]/ ;
				
				if(username == ''){
					alert('Please enter valid username');
					return false;
				} else if(!emailFilter.test(email1) || email == ''){
					alert('Please enter valid email address');
					return false;
				} else if(email.match(illegalChars)){
					alert( "The email address contains illegal characters.");
					return false;
				} else {
					return true;
				}
				
			});
		});
	</script>

</html>
