<?php
class CustomLogin
{
    /**
     * Function trigger on module enable, disable, install etc...
     *
     * @param String Module name
     * @param String Event Type
     */
    function vtlib_handler($moduleName, $eventType) 
    {
        global $adb;
        if($eventType == 'module.postinstall') 
        {   
            include_once('vtlib/Vtiger/Module.php');
            $moduleInstance = Vtiger_Module::getInstance($moduleName);

            // Inserting values into settings table
            $field_id = $adb->getUniqueID('vtiger_settings_field');
            $block_id = getSettingsBlockId('LBL_OTHER_SETTINGS');
            $getSequence = $adb->pquery("SELECT max(sequence) AS max_seq FROM vtiger_settings_field WHERE blockid = ?", array($block_id));
            $sequence = $adb->query_result($getSequence, 0, 'max_seq');

            $adb->pquery('INSERT INTO vtiger_settings_field(fieldid, blockid, name, iconpath, description, linkto, sequence)
                    VALUES (?,?,?,?,?,?,?)', array($field_id, $block_id, 'Custom Login', '', 'Custom Login for CRM',
                        'index.php?module=CustomLogin&parent=Settings&view=Detail', $sequence));

            $this->move_installable_files_to_user_templates();

            // Check ws_entity added
            $checkEntry = $adb->pquery('select * from vtiger_ws_entity where name = ?', array($moduleName));
            $count = $adb->num_rows($checkEntry);
            if($count == 0) {
                $adb->pquery('insert into vtiger_ws_entity (name, handler_path, handler_class, ismodule) values (?, ?, ?, ?)', array($moduleName, 'include/Webservices/VtigerModuleOperation.php', 'VtigerModuleOperation', 1));
            }
        } 
        else if($eventType == 'module.disabled') {
            // TODO Handle actions before this module is being uninstalled.
        } 
        else if($eventType == 'module.enabled') {
            // TODO Handle actions before this module is being installed.
        } 
        else if($eventType == 'module.preuninstall') {
            // TODO Handle actions when this module is about to be deleted.
        } 
        else if($eventType == 'module.preupdate') {
            // TODO Handle actions before this module is updated.
        } 
        else if($eventType == 'module.postupdate') {
            // TODO Handle actions after this module is updated.
        }
    }

    /**
     * Move Installatable files to User templates
     */
    public function move_installable_files_to_user_templates()
    {
        global $root_directory, $log;
        copy($root_directory . 'modules/CustomLogin/Install/Login.tpl', $root_directory . 'layouts/v7/modules/Users/Login.tpl');
        copy($root_directory . 'modules/CustomLogin/Install/Login.Default.tpl', $root_directory . 'layouts/v7/modules/Users/Login.Default.tpl');
    }
}
